
<?php
// ---------- DATABASE CONNECTION ----------
$host   = "localhost";
$user   = "root";
$pass   = "";
$dbname = "dreams"; // ✅ YOUR DATABASE NAME

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// ---------- FETCH USERS ----------
$users = [];
$sql = "SELECT username FROM users";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $users[] = $row['username'];
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Dreams Users</title>
  <style>
    body {
      background: #0d0d0d;
      color: white;
      font-family: Arial, sans-serif;
      padding: 20px;
    }
    .user {
      padding: 12px;
      margin: 8px 0;
      background: #1c1c1c;
      border-radius: 10px;
    }
  </style>
</head>
<body>

<h2>Users List</h2>

<?php if (empty($users)) { ?>
  <p>No users found</p>
<?php } else { ?>
  <?php foreach ($users as $username) { ?>
    <div class="user">
      <?php echo htmlspecialchars($username); ?>
    </div>
  <?php } ?>
<?php } ?>

</body>
</html>
