
<?php 
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// DB connect
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

$BASE_URL = "http://10.91.25.51/dreams/";

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} 
catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    exit;
}

try {

    // 1️⃣ RANDOM 5 USERS
    $stmtUsers = $connection->query("
        SELECT id, username, name, caption, media_type, reels_video 
        FROM login
        ORDER BY RAND()
        LIMIT 5
    ");
    $users = $stmtUsers->fetchAll(PDO::FETCH_ASSOC);

    // 2️⃣ RANDOM 5 WALLPAPERS (each user gets 1 different wallpaper)
    // ➤ wallpapers table से caption भी शामिल किया
    $stmtWalls = $connection->query("
        SELECT file_url, caption 
        FROM wallpapers
        ORDER BY RAND()
        LIMIT 5
    ");
    $wallpapers = $stmtWalls->fetchAll(PDO::FETCH_ASSOC);

    $finalData = [];
    $index = 0;

    // 3️⃣ Assign 1 wallpaper to each user
    foreach ($users as $u) {

        if (!isset($wallpapers[$index])) break;

        // Wallpaper file URL + caption
        $wallpaperFullUrl = $BASE_URL . $wallpapers[$index]['file_url'];
        $wallpaperCaption = $wallpapers[$index]['caption'];

        $index++;

        // Final output
        $finalData[] = [
            "id" => $u['id'],
            "username" => $u['username'],
            "name" => $u['name'],
            "caption" => $u['caption'],
            "media_type" => $u['media_type'],
            "reels_video" => $BASE_URL . $u['reels_video'],

            // 🔥 wallpapers array with file_url + caption
            "wallpapers" => [
                [
                    "file_url" => $wallpaperFullUrl,
                    "caption" => $wallpaperCaption
                ]
            ]
        ];
    }

    echo json_encode([
        "success" => true,
        "data" => $finalData
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

} 
catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
