



<?php
// Database connection
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$base_url = "http://10.91.25.51/dreams/";

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Get current user_id
$current_user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($current_user_id <= 0) {
    echo json_encode(["error" => "Invalid user_id"]);
    exit;
}

// Step 1: Get related user_ids (followers + following)
$sql = "
    SELECT DISTINCT follow_id AS related_user_id
    FROM follows
    WHERE user_id = ?
    UNION
    SELECT DISTINCT user_id AS related_user_id
    FROM follows
    WHERE follow_id = ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$current_user_id, $current_user_id]);
$related_users = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Step 2: Add self user_id
$related_users[] = $current_user_id;

// Step 3: Build placeholders
$related_placeholders = implode(',', array_fill(0, count($related_users), '?'));

// Step 4: Common SELECT (only videos)
$select_with_joins = "
    SELECT 
        rv.id,
        rv.user_id,
        l.username,
        l.name,
        rv.caption,
        CONCAT(?, rv.reels_video) AS media_url,
        rv.media_type AS type,
        rv.created_at,
        CONCAT(?, rv.thumbnail) AS thumbnail,
        (SELECT COUNT(*) FROM likese WHERE post_id = rv.id) AS like_count,
        'reels_videose' AS source_table
    FROM reels_videose rv
    JOIN login l ON rv.user_id = l.id
    WHERE rv.media_type = 'video'
";

// Step 5: Final query — only latest 10 videos
$sql_final = "
(
    $select_with_joins
    AND rv.user_id IN ($related_placeholders)
)
UNION
(
    $select_with_joins
    AND rv.user_id NOT IN ($related_placeholders)
)
ORDER BY created_at DESC
LIMIT 10
";

// Step 6: Bind parameters
$params = [$base_url, $base_url];
$params = array_merge($params, $related_users);
$params = array_merge($params, [$base_url, $base_url]);
$params = array_merge($params, $related_users);

// Step 7: Execute and fetch
$stmt = $pdo->prepare($sql_final);
$stmt->execute($params);
$videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Step 8: Output JSON
header('Content-Type: application/json');
echo json_encode($videos, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
