
<?php
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$base_url = "http://10.91.25.51/dreams/";

$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$current_user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
if ($current_user_id <= 0) {
    echo json_encode(["error" => "Invalid user_id"]);
    exit;
}

// ---- RELATED USERS ----
$sql = "
    SELECT DISTINCT follow_id AS related_user_id
    FROM follows WHERE user_id = ?
    UNION
    SELECT DISTINCT user_id AS related_user_id
    FROM follows WHERE follow_id = ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$current_user_id, $current_user_id]);
$related_users = $stmt->fetchAll(PDO::FETCH_COLUMN);
$related_users[] = $current_user_id;

// ---- WATCHED (videos that current user already viewed) ----
$stmt = $pdo->prepare("SELECT username FROM login WHERE id = ?");
$stmt->execute([$current_user_id]);
$current_username = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT video_id FROM video_watches WHERE username = ?");
$stmt->execute([$current_username]);
$watched_videos = $stmt->fetchAll(PDO::FETCH_COLUMN);

// prepare placeholders for IN() clauses
$related_ph = implode(',', array_fill(0, count($related_users), '?'));
$watched_ph = !empty($watched_videos) ? implode(',', array_fill(0, count($watched_videos), '?')) : null;

// ---- SELECT COMMON ----
$select = "
    SELECT 
        rv.id,
        rv.user_id,
        l.username,
        l.name,
        rv.caption,
        l.caption AS user_caption,
        CONCAT(?, rv.reels_video) AS media_url,
        CONCAT(?, l.reels_video) AS user_reels_url,
        CONCAT(?, rv.thumbnail) AS thumbnail,
        CONCAT(?, rv.music_url) AS music_url,
        rv.media_type AS type,
        rv.created_at,
        (SELECT COUNT(*) FROM likese WHERE post_id = rv.id) AS like_count
    FROM reels_videose rv
    JOIN login l ON rv.user_id = l.id
";

// ---- RELATED QUERY (exclude watched videos if any) ----
$sql_related = "$select WHERE rv.user_id IN ($related_ph)";
$params_related = array_merge([$base_url,$base_url,$base_url,$base_url], $related_users);

if ($watched_ph) {
    $sql_related .= " AND rv.id NOT IN ($watched_ph)";
    $params_related = array_merge($params_related, $watched_videos);
}

$sql_related .= " ORDER BY rv.created_at DESC LIMIT 5";

$stmt = $pdo->prepare($sql_related);
$stmt->execute($params_related);
$related_videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ---- NON RELATED (exclude watched videos if any) ----
$sql_non = "$select WHERE rv.user_id NOT IN ($related_ph)";
$params_non = array_merge([$base_url,$base_url,$base_url,$base_url], $related_users);

if ($watched_ph) {
    $sql_non .= " AND rv.id NOT IN ($watched_ph)";
    $params_non = array_merge($params_non, $watched_videos);
}

$sql_non .= " ORDER BY rv.created_at DESC LIMIT 5";

$stmt = $pdo->prepare($sql_non);
$stmt->execute($params_non);
$non_related_videos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ---- MERGE BOTH ----
$videos = array_merge($related_videos, $non_related_videos);

// ---- If less than 10, fetch extra (exclude watched videos) ----
$need = 10 - count($videos);

if ($need > 0) {
    $sql_extra = "$select";

    // exclude watched videos from extra fetch as well
    if ($watched_ph) {
        $sql_extra .= " WHERE rv.id NOT IN ($watched_ph)";
        $params_extra = array_merge([$base_url,$base_url,$base_url,$base_url], $watched_videos);
    } else {
        $params_extra = [$base_url,$base_url,$base_url,$base_url];
    }

    $sql_extra .= " ORDER BY RAND() LIMIT $need";

    $stmt = $pdo->prepare($sql_extra);
    $stmt->execute($params_extra);

    $extra = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $videos = array_merge($videos, $extra);
}

// -------------------------------------------------------
// 🚀 5 VIDEO + 5 IMAGE LOGIC (WITH WATCHED-EXCLUSION APPLIED)
// -------------------------------------------------------

// Separate arrays for videos and images from the merged set
$videos_only = array_values(array_filter($videos, fn($v) => $v['type'] === 'video'));
$images_only = array_values(array_filter($videos, fn($v) => $v['type'] === 'image'));

// Count current available
$video_count = count($videos_only);
$image_count = count($images_only);

$final = [];

/*
 CASE 1: If there are >= 10 videos available overall (in DB, excluding watched),
         we must return 5 videos + 5 images (images fetched from DB if not already in $images_only).
         Note: "10 videos available" check means: we check videos in DB (excluding watched).
         So fetch count of available videos from DB.
*/

// get total available video count in DB (excluding watched)
$sql_count_v = "SELECT COUNT(*) FROM reels_videose rv WHERE rv.media_type = 'video'";
$params_count_v = [];

if ($watched_ph) {
    $sql_count_v .= " AND rv.id NOT IN ($watched_ph)";
    $params_count_v = $watched_videos;
}

$stmt = $pdo->prepare($sql_count_v);
$stmt->execute($params_count_v);
$db_video_total = intval($stmt->fetchColumn());

// ---------- CASE 1: DB has 10 or more videos (excluding watched) ----------
if ($db_video_total >= 10) {
    // take top 5 videos from our already-fetched list (if not enough, fetch latest ones)
    $final_videos = array_slice($videos_only, 0, 5);

    // If we don't have 5 videos in $final_videos (because merged earlier didn't include enough),
    // fetch latest videos from DB (excluding watched) to fill up to 5.
    if (count($final_videos) < 5) {
        $need_v = 5 - count($final_videos);
        $sql_more_v = "$select WHERE rv.media_type = 'video'";
        $params_more_v = [$base_url,$base_url,$base_url,$base_url];

        if ($watched_ph) {
            $sql_more_v .= " AND rv.id NOT IN ($watched_ph)";
            $params_more_v = array_merge($params_more_v, $watched_videos);
        }

        $sql_more_v .= " ORDER BY rv.created_at DESC LIMIT $need_v";
        $stmt = $pdo->prepare($sql_more_v);
        $stmt->execute($params_more_v);
        $more_v = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $final_videos = array_merge($final_videos, $more_v);
    }

    // Now fetch 5 images from DB (excluding watched videos irrelevant for images)
    $sql_img = "$select WHERE rv.media_type = 'image' ORDER BY rv.created_at DESC LIMIT 5";
    $params_img = [$base_url,$base_url,$base_url,$base_url];

    // If you want to exclude images that reference watched video ids (rare), you could add NOT IN watched here as well.
    // For now we don't exclude images based on watched videos (images are independent).
    $stmt = $pdo->prepare($sql_img);
    $stmt->execute($params_img);
    $images_db = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // If images DB < 5, fill remaining slots with more videos (excluding watched)
    if (count($images_db) < 5) {
        $need_img_fill = 5 - count($images_db);

        // fetch additional videos (skip first 5 already used)
        $sql_fallback_v = "$select WHERE rv.media_type = 'video'";
        $params_fallback_v = [$base_url,$base_url,$base_url,$base_url];
        if ($watched_ph) {
            $sql_fallback_v .= " AND rv.id NOT IN ($watched_ph)";
            $params_fallback_v = array_merge($params_fallback_v, $watched_videos);
        }
        $sql_fallback_v .= " ORDER BY rv.created_at DESC LIMIT " . ($need_img_fill + 5); // fetch some extras
        $stmt = $pdo->prepare($sql_fallback_v);
        $stmt->execute($params_fallback_v);
        $candidates_v = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // remove any that are already in $final_videos (by id)
        $used_ids = array_column($final_videos, 'id');
        $fallback = [];
        foreach ($candidates_v as $cv) {
            if (!in_array($cv['id'], $used_ids)) {
                $fallback[] = $cv;
                if (count($fallback) >= $need_img_fill) break;
            }
        }

        $images_db = array_merge($images_db, $fallback);
    }

    // final = 5 videos + first 5 images_db (or fallback)
    $final = array_merge(array_slice($final_videos, 0, 5), array_slice($images_db, 0, 5));
}

// ---------- CASE 2: 6–9 videos in DB → return 5 videos only ----------
else if ($db_video_total >= 5) {
    // get top 5 videos (exclude watched)
    $sql_top5 = "$select WHERE rv.media_type = 'video'";
    $params_top5 = [$base_url,$base_url,$base_url,$base_url];
    if ($watched_ph) {
        $sql_top5 .= " AND rv.id NOT IN ($watched_ph)";
        $params_top5 = array_merge($params_top5, $watched_videos);
    }
    $sql_top5 .= " ORDER BY rv.created_at DESC LIMIT 5";
    $stmt = $pdo->prepare($sql_top5);
    $stmt->execute($params_top5);
    $final = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// ---------- CASE 3: 1–4 videos in DB → return available videos ----------
else if ($db_video_total > 0) {
    $sql_some = "$select WHERE rv.media_type = 'video'";
    $params_some = [$base_url,$base_url,$base_url,$base_url];
    if ($watched_ph) {
        $sql_some .= " AND rv.id NOT IN ($watched_ph)";
        $params_some = array_merge($params_some, $watched_videos);
    }
    $sql_some .= " ORDER BY rv.created_at DESC";
    $stmt = $pdo->prepare($sql_some);
    $stmt->execute($params_some);
    $final = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// ---------- CASE 4: no videos available (after excluding watched) ----------
else {
    $final = [];
}

// Ensure exactly max 10 items and shuffle
$final = array_slice($final, 0, 10);
shuffle($final);

header('Content-Type: application/json');
echo json_encode($final, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
