


<?php
header("Content-Type: application/json");

// ✅ Database connection
$servername = "localhost";
$username   = "root";    // change as per your db
$password   = "";        // change as per your db
$dbname     = "dreams";  // your database name

$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]));
}

// ✅ Get request data
$data = json_decode(file_get_contents("php://input"), true);

$storyId = intval($data['storyId']);
$userId  = intval($data['userId']);
$action  = $data['action'];

$response = ["success" => false];

// ✅ Story watched action
if ($action === "watched") {
    $stmt = $conn->prepare("INSERT IGNORE INTO story_views (story_id, user_id) VALUES (?, ?)");
    $stmt->bind_param("ii", $storyId, $userId);
    if ($stmt->execute()) {
        $response["success"] = true;
    }
    $stmt->close();
}

// ✅ Like action
if ($action === "like") {
    $stmt = $conn->prepare("INSERT INTO story_likes (story_id, user_id) VALUES (?, ?) 
                            ON DUPLICATE KEY UPDATE user_id = user_id");
    $stmt->bind_param("ii", $storyId, $userId);
    if ($stmt->execute()) {
        $response["success"] = true;
    }
    $stmt->close();
}

// ✅ Unlike action
if ($action === "unlike") {
    $stmt = $conn->prepare("DELETE FROM story_likes WHERE story_id = ? AND user_id = ?");
    $stmt->bind_param("ii", $storyId, $userId);
    if ($stmt->execute()) {
        $response["success"] = true;
    }
    $stmt->close();
}

echo json_encode($response);

$conn->close();
?>
