

<?php
header("Content-Type: application/json");

// ===== Database Connection =====
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$conn = new mysqli($host, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "DB Connection Failed: " . $conn->connect_error]));
}

// ===== Input Params =====
$story_id = isset($_POST['story_id']) ? intval($_POST['story_id']) : 0;
$user_id  = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$action   = isset($_POST['action']) ? $_POST['action'] : "";

if (!$story_id || !$user_id || !$action) {
    echo json_encode(["success" => false, "message" => "Invalid params"]);
    exit;
}

// ===== Action Handling =====
if ($action === "like") {
    $sql = "INSERT INTO story_likes (story_id, user_id, liked, watched) 
            VALUES ($story_id, $user_id, 1, 0)
            ON DUPLICATE KEY UPDATE liked = 1";
} elseif ($action === "unlike") {
    $sql = "UPDATE story_likes SET liked = 0 WHERE story_id = $story_id AND user_id = $user_id";
} elseif ($action === "watched") {
    $sql = "INSERT INTO story_likes (story_id, user_id, watched) 
            VALUES ($story_id, $user_id, 1)
            ON DUPLICATE KEY UPDATE watched = 1";
} else {
    echo json_encode(["success" => false, "message" => "Unknown action"]);
    exit;
}

// ===== Execute Query =====
if ($conn->query($sql) === TRUE) {
    echo json_encode(["success" => true, "message" => "Action updated"]);
} else {
    echo json_encode(["success" => false, "message" => $conn->error]);
}

$conn->close();
?>
