<?php
header("Content-Type: application/json");

// ✅ Base URLs
$storyBaseUrl = "http://10.91.25.51/story/";
$reelBaseUrl  = "http://10.91.25.51/dreams/";

// ✅ Database connection
$servername = "localhost";
$username   = "root";    // change as per your db
$password   = "";        // change as per your db
$dbname     = "dreams";  // your database name

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Database connection failed: " . $conn->connect_error]));
}

$userId = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;
$response = ["success" => false, "stories" => []];

if ($userId <= 0) {
    $response["message"] = "Invalid user_id";
    echo json_encode($response);
    exit;
}

// ✅ केवल 24 घंटे वाली stories निकालना + likes/views count जोड़ना
$sql = "
    SELECT 
        s.id,
        s.user_id,
        s.media_url,
        s.media_type,
        s.created_at,
        s.expires_at,
        s.music_url,
        s.gradient_index,
        COUNT(CASE WHEN sl.liked = 1 THEN 1 END) as total_likes,
        COUNT(CASE WHEN sl.watched = 1 THEN 1 END) as total_views
    FROM stories s
    LEFT JOIN story_likes sl ON s.id = sl.story_id
    WHERE s.user_id = ?
      AND s.created_at >= NOW() - INTERVAL 24 HOUR
      AND s.expires_at > NOW()
    GROUP BY s.id
    ORDER BY s.created_at DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$stories = [];
while ($row = $result->fetch_assoc()) {

    // ✅ reels_video के लिए अलग base URL लगाना
    if (strpos($row['media_url'], 'reels_video') !== false) {
        $row['media_url'] = $reelBaseUrl . $row['media_url'];
    } else {
        $row['media_url'] = $storyBaseUrl . $row['media_url'];
    }


    // ✅ music_url के लिए हमेशा story base url
    if (!empty($row['music_url'])) {
        $row['music_url'] = $storyBaseUrl . $row['music_url'];
    }

    $stories[] = $row;
}

$response["success"] = true;
$response["stories"] = $stories;

echo json_encode($response);
$conn->close();
?>
