





<?php
header("Content-Type: application/json");

// ---- Database connection ----
$servername = "localhost";
$username = "root";
$password = "";
$database = "dreams";

// Create connection
$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die(json_encode([
        "success" => false,
        "message" => "Connection failed: " . $conn->connect_error
    ]));
}

// ---- Prepare upload directory ----
$uploadDir = 'uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// ---- Upload logic ----
if(isset($_POST['user_id'], $_POST['post_id']) && isset($_FILES['thumbnail'])){
    $user_id = intval($_POST['user_id']);
    $post_id = intval($_POST['post_id']);
    
    $file = $_FILES['thumbnail'];
    $fileName = time() . "_" . basename($file["name"]);
    $targetFilePath = $uploadDir . $fileName;

    if(move_uploaded_file($file["tmp_name"], $targetFilePath)){
        $stmt = $conn->prepare("INSERT INTO story_thubnal (post_id, user_id, story_thubnal) VALUES (?, ?, ?)");
        $stmt->bind_param("iis", $post_id, $user_id, $targetFilePath); // store full path

        if($stmt->execute()){
            echo json_encode([
                "success" => true,
                "message" => "Thumbnail uploaded successfully!",
                "thumbnail_url" => "http://YOUR_SERVER_IP/dreams/" . $targetFilePath // full path
            ]);
        } else {
            echo json_encode(["success" => false, "message" => "DB insert failed"]);
        }
        $stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "Failed to upload file"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Missing required fields"]);
}

$conn->close();
?>
