<?php
header("Content-Type: application/json");
require_once 'db_connect.php';

// 🌐 Base URLs
$baseUrl = "http://10.91.25.51/story/";
$reelBaseUrl = "http://10.91.25.51/dreams/";

// Get user ID from request
$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;
$response = ['success' => false, 'message' => '', 'stories' => []];

if (!$userId) {
    $response['message'] = 'User ID is required';
    echo json_encode($response);
    exit;
}

try {
    // ✅ Check user & Screen value
    $stmt = $pdo->prepare("SELECT id, Screen FROM login WHERE id = ?");
    $stmt->execute([$userId]);
    $userRow = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$userRow) {
        $response['message'] = 'User not found';
        echo json_encode($response);
        exit;
    }

    $screen = (int)$userRow['Screen'];

    // ✅ SAME QUERY FOR BOTH CASES (ONLY LIMIT ADDED)
    $stmt = $pdo->prepare("
        SELECT s.*, l.username, l.reels_video
        FROM stories s
        JOIN login l ON s.user_id = l.id
        WHERE s.user_id IN (
            SELECT follow_id FROM follows WHERE user_id = ?
        )
        AND s.expires_at > NOW()
        AND NOT EXISTS (
            SELECT 1
            FROM story_likes sl
            WHERE sl.story_id = s.id
            AND sl.user_id = ?
        )
        ORDER BY s.user_id, s.created_at DESC
        LIMIT 10
    ");

    $stmt->execute([$userId, $userId]);
    $stories = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($stories) {
        $groupedStories = [];

        foreach ($stories as &$story) {

            // ✅ Add reels video URL
            if (!empty($story['reels_video'])) {
                $story['reels_video'] = $reelBaseUrl . $story['reels_video'];
            }

            // ✅ Add story media URL
            if (!empty($story['media_url'])) {
                $story['media_url'] = $baseUrl . $story['media_url'];
            }

             // ✅ Add story media URL
            if (!empty($story['music_url'])) {
                $story['music_url'] = $baseUrl . $story['music_url'];
            }

            // ✅ Clean empty navigate
            if (empty($story['navigate'])) {
                unset($story['navigate']);
            }

            // ✅ Group by user
            $groupedStories[$story['user_id']][] = $story;
        }

        $response = [
            'success' => true,
            'stories' => array_values($groupedStories)
        ];
    } else {
        $response['message'] = 'No stories available';
    }

} catch (PDOException $e) {
    $response['message'] = 'Database error: ' . $e->getMessage();
}

echo json_encode($response);
?>
