<?php
header("Content-Type: application/json");

// ✅ Database connection
$servername = "localhost";
$username   = "root";       // change as per your db
$password   = "";           // change as per your db
$dbname     = "dreams";     // your database name

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode([
        "success" => false,
        "message" => "Database connection failed: " . $conn->connect_error
    ]));
}

// ✅ Check request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $story_id = $_POST['id'] ?? null;

    if (!$story_id) {
        echo json_encode(["success" => false, "message" => "Missing story id"]);
        exit;
    }

    // ✅ Delete story by id
    $stmt = $conn->prepare("DELETE FROM stories WHERE id = ?");
    $stmt->bind_param("i", $story_id);

    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Story deleted successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to delete story"]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}
?>
