

<?php
$host = "localhost";  // या आपका server
$user = "root";       // आपका DB username
$pass = "";           // आपका DB password
$dbname = "dreams"; // आपका DB name

$conn = new mysqli($host, $user, $pass, $dbname);

// Error check
if ($conn->connect_error) {
    die("Database Connection Failed: " . $conn->connect_error);
}


// 🌐 Base URL (अपने server का IP/Domain बदलें)
$baseUrl = "http://10.161.116.51/story/";

// ✅ Request से user_id लो
$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;

$response = ["success" => false, "stories" => []];

if ($userId > 0) {
    // 🔍 user_id match करके stories लाओ
    $sql = "SELECT id, user_id, media_url, media_type, created_at, music_url, gradient_index 
            FROM stories 
            WHERE user_id = ? 
            ORDER BY created_at DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    $stories = [];
    while ($row = $result->fetch_assoc()) {
        $stories[] = [
            "id" => (int)$row["id"],
            "user_id" => (int)$row["user_id"],
            "media_url" => $baseUrl . $row["media_url"],
            "media_type" => $row["media_type"],
            "created_at" => $row["created_at"],
            "music_url" => $row["music_url"] ? $baseUrl . $row["music_url"] : null,
            "gradient_index" => (int)$row["gradient_index"]
        ];
    }

    if (!empty($stories)) {
        $response["success"] = true;
        $response["stories"] = $stories;
    }
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
