
<?php
header('Content-Type: application/json');

// Database configuration
$db_host = 'localhost';
$db_name = 'dreams';
$db_user = 'root';
$db_pass = '';

// Get input data
$data = json_decode(file_get_contents('php://input'), true);
$userId = $data['user_id'] ?? null;
$fcmToken = $data['fcm_token'] ?? null;

// Validate input
if (!$userId || !$fcmToken) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing user_id or fcm_token']);
    exit;
}

try {
    // Create database connection
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if user exists
    $checkStmt = $pdo->prepare("SELECT id FROM login WHERE id = :user_id");
    $checkStmt->execute([':user_id' => $userId]);

    if ($checkStmt->rowCount() === 0) {
        http_response_code(404);
        echo json_encode(['error' => 'User not found']);
        exit;
    }

    // Update FCM token in login table
    $updateStmt = $pdo->prepare("
        UPDATE login 
        SET fcm_token = :fcm_token 
        WHERE id = :user_id
    ");
    $updateStmt->execute([
        ':fcm_token' => $fcmToken,
        ':user_id' => $userId
    ]);

    echo json_encode([
        'success' => true,
        'message' => 'FCM token updated successfully'
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>
