
<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// DB Connection
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$BASE_URL = "http://10.144.183.51/dreams/";

try {
    $connection = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username,
        $password,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    // ⭐ Only latest post for user_id = 1
    $stmt = $connection->prepare("
        SELECT * FROM wallpapers 
        WHERE user_id = 1 
        ORDER BY id DESC 
        LIMIT 1
    ");

    $stmt->execute();
    $post = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($post) {

        // Add full URL path
        if (!empty($post['file_url'])) {
            $post['full_url'] = $BASE_URL . $post['file_url'];
        }

        echo json_encode([
            "success" => true,
            "post" => $post
        ]);

    } else {

        echo json_encode([
            "success" => false,
            "message" => "No uploads found for user_id = 1"
        ]);
    }

} catch (Exception $e) {

    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
}
?>
