<?php
$mysqli = new mysqli("localhost", "root", "", "dreams");

if ($mysqli->connect_errno) {
    http_response_code(500);
    echo "Failed to connect to MySQL: " . $mysqli->connect_error;
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

if (isset($data['poll']) && $data['poll'] == true) {
    $stmt = $mysqli->prepare("SELECT * FROM signaling WHERE `to`=?");
    $stmt->bind_param("s", $data['for']);
    $stmt->execute();
    $result = $stmt->get_result();
    $messages = [];

    while ($row = $result->fetch_assoc()) {
        $messages[] = json_decode($row['data'], true);
    }

    // Delete after delivering
    $del = $mysqli->prepare("DELETE FROM signaling WHERE `to`=?");
    $del->bind_param("s", $data['for']);
    $del->execute();

    echo json_encode($messages);
    exit();
}

// Save signal
$stmt = $mysqli->prepare("INSERT INTO signaling (`from`, `to`, `data`) VALUES (?, ?, ?)");
$json = json_encode($data);
$stmt->bind_param("sss", $data['from'], $data['to'], $json);
$stmt->execute();

echo "OK";
?>
