


<?php
// Database connection
$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Base URL
    $base_url = "http://10.190.187.51/dreams/";

    // Get userId from URL, fallback = 0
    $userId = isset($_GET['userId']) ? intval($_GET['userId']) : 0;

    $sql = "
        SELECT 
            rv.id AS reel_id,
            rv.caption AS reel_caption,
            rv.reels_video AS reel_video,
            rv.user_id AS reel_user_id,
            rv.media_type,
            rv.thumbnail,
            rv.created_at AS reel_created,

            -- Likes user info
            l.id AS like_id,
            l.username AS like_username,
            lu.id AS like_user_id,
            lu.username AS like_user_username,
            lu.reels_video AS like_user_reels,
            lu.caption AS like_user_caption,

            -- Comments user info
            c.id AS comment_id,
            c.comment,
            c.username AS comment_username,
            cu.id AS comment_user_id,
            cu.username AS comment_user_username,
            cu.reels_video AS comment_user_reels,
            cu.caption AS comment_user_caption,
            c.created_at AS comment_created

        FROM reels_videose rv
        LEFT JOIN likese l 
            ON rv.id = l.post_id
        LEFT JOIN login lu 
            ON l.username = lu.username
        LEFT JOIN commentse c 
            ON rv.id = c.post_id
        LEFT JOIN login cu 
            ON c.username = cu.username
        WHERE rv.user_id = :user_id
        ORDER BY rv.created_at DESC
    ";

    $stmt = $conn->prepare($sql);
    $stmt->execute(['user_id' => $userId]);

    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Append base_url to file paths
    foreach ($result as &$row) {
        if (!empty($row['reel_video'])) {
            $row['reel_video'] = $base_url . $row['reel_video'];
        }
        if (!empty($row['thumbnail'])) {
            $row['thumbnail'] = $base_url . $row['thumbnail'];
        }
        if (!empty($row['like_user_reels'])) {
            $row['like_user_reels'] = $base_url . $row['like_user_reels'];
        }
        if (!empty($row['comment_user_reels'])) {
            $row['comment_user_reels'] = $base_url . $row['comment_user_reels'];
        }
    }

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

} catch (PDOException $e) {
    echo "DB Error: " . $e->getMessage();
}



