<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>🔄 Auto Notification Runner</title>
    <style>
        body { font-family: Arial; background: #f9f9f9; padding: 30px; }
        #log { margin-top: 20px; color: green; }
    </style>
</head>
<body>
    <h2>🔄 Auto Notification Runner (every 15 seconds)</h2>
    <p id="log">⏳ Waiting for first check...</p>

    <script>
        function sendNotification() {
            fetch('video.php')
                .then(response => response.text())
                .then(data => {
                    const time = new Date().toLocaleTimeString();
                    document.getElementById('log').innerText = `${time} - ${data}`;
                    console.log(`[${time}] ${data}`);
                })
                .catch(error => {
                    document.getElementById('log').innerText = `❌ Error: ${error}`;
                    console.error(error);
                });
        }

        // First run immediately
        sendNotification();
        // Repeat every 15 seconds
        setInterval(sendNotification, 15000);
    </script>
</body>
</html>
