


<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'vendor/autoload.php';

use Google\Auth\OAuth2;
use GuzzleHttp\Client;

$serviceAccountPath = __DIR__ . '/service-account.json';
$projectId = 'dreams-9559e';

$fcmToken = "ftZ5P_0FRme_ZsoXkOEcN4:APA91bHZwnlzABq3znd26M9Tk0IC1knTLU-P5s65PP-XQxcILMfZdJAtaF2ixW-IXrFPjecxU_LmA7uc3mGJtpf1jwvKuWIZ0lT1-Q64sBzYkvgIooiIsIU";
$badgeCount = 1;

// AUTH TOKEN
$credentials = json_decode(file_get_contents($serviceAccountPath), true);

$oauth = new OAuth2([
    'audience' => 'https://oauth2.googleapis.com/token',
    'issuer' => $credentials['client_email'],
    'signingAlgorithm' => 'RS256',
    'signingKey' => $credentials['private_key'],
    'tokenCredentialUri' => 'https://oauth2.googleapis.com/token',
    'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
]);

$token = $oauth->fetchAuthToken();
$accessToken = $token['access_token'];

// CORRECTED FCM PAYLOAD - SIMPLIFIED AND PROPER
$fcmMessage = [
    "message" => [
        "token" => $fcmToken,

        "notification" => [
            "title" => "New Message",
            "body"  => "You received a new message!"
        ],

        "data" => [
            "badge" => (string)$badgeCount,
            
        ],

        "android" => [
            "notification" => [
                "sound" => "default"
            ]
        ],

        "apns" => [
            "payload" => [
                "aps" => [
                    "alert" => [
                        "title" => "New Message",
                        "body"  => "You received a new message!"
                    ],
                    "sound" => "default",
                    "badge" => $badgeCount
                ]
            ]
        ]
    ]
];


// SEND TO FCM
$client = new Client();

try {
    $response = $client->post(
        "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send",
        [
            'headers' => [
                'Authorization' => "Bearer $accessToken",
                'Content-Type'  => 'application/json'
            ],
            'json' => $fcmMessage
        ]
    );

    $responseBody = $response->getBody();
    echo "Notification Sent Successfully!\n";
    echo "Response: " . $responseBody . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    
    // More detailed error info
    if (method_exists($e, 'getResponse')) {
        $response = $e->getResponse();
        if ($response) {
            echo "Response Body: " . $response->getBody() . "\n";
        }
    }
}