


<?php
// Database connection
$host = "localhost";
$dbname = "dreams";   // आपकी DB का नाम
$username = "root";   // DB username
$password = "";       // DB password

$baseUrl = "http://10.231.249.139/dreams/"; // Define the base URL

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Request से user_id लेना
    $userId = isset($_GET['user_id']) ? $_GET['user_id'] : '';

    if ($userId != '') {
        // Query user_id match करके
        $stmt = $conn->prepare("SELECT * FROM reels_videose WHERE user_id = :user_id ORDER BY created_at DESC");
        $stmt->bindParam(':user_id', $userId);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($result) {
            // ✅ प्रत्येक row में video और thumbnail URL prepend करो
            foreach ($result as &$row) {
                if (!empty($row['reels_video'])) {
                    $row['reels_video'] = $baseUrl . $row['reels_video'];
                }
                if (!empty($row['thumbnail'])) {
                    $row['thumbnail'] = $baseUrl . $row['thumbnail'];
                }
            }

            echo json_encode([
                "status" => "success",
                "data" => $result
            ]);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "No reels found for this user"
            ]);
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "user_id is required"
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
