


<?php
header("Content-Type: application/json");

/* ================= DATABASE ================= */

$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

$base_url = "http://10.69.252.51/dreams/";

try {
    $pdo = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username,
        $password
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ]);
    exit;
}

/* ================= DATE ================= */

$date = $_GET['date'] ?? date('Y-m-d');

$start = $date . " 00:00:00";
$end   = $date . " 23:59:59";

/* ================= QUERY ================= */

$sql = "
    SELECT 
        id,
        caption,
        reels_video,
        media_type,
        thumbnail,
        created_at
    FROM reels_videose
    WHERE created_at BETWEEN :start AND :end
    ORDER BY created_at DESC
";

$stmt = $pdo->prepare($sql);
$stmt->bindParam(":start", $start);
$stmt->bindParam(":end", $end);
$stmt->execute();

$data = [];

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {

    // ✅ image OR video url
    $row['reels_video'] = $base_url . $row['reels_video'];

    // ✅ thumbnail only for video
    if ($row['media_type'] === 'video' && !empty($row['thumbnail'])) {
        $row['thumbnail'] = $base_url . $row['thumbnail'];
    } else {
        $row['thumbnail'] = null;
    }

    $data[] = $row;
}

echo json_encode([
    "success" => true,
    "date" => $date,
    "count" => count($data),
    "data" => $data
]);
