<?php
$host = "localhost";
$user = "root";
$pass = "";
$db = "dreams";

$conn = new mysqli($host, $user, $pass, $db);

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['user_id'])) {
    $userId = $_GET['user_id'];
    $stmt = $conn->prepare("SELECT latitude, longitude FROM locations WHERE user_id = ?");
    $stmt->bind_param("s", $userId);
    $stmt->execute();
    $stmt->bind_result($lat, $lng);
    
    if ($stmt->fetch()) {
        echo json_encode([
            "status" => "success",
            "latitude" => $lat,
            "longitude" => $lng
        ]);
    } else {
        echo json_encode(["status" => "error", "message" => "Location not found"]);
    }

    $stmt->close();
}

$conn->close();
?>
