


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Video Player & Embed</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .video-section {
            margin: 20px 0;
            text-align: center;
        }
        .embed-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .embed-code {
            background: #2d3748;
            color: #e2e8f0;
            padding: 15px;
            border-radius: 5px;
            font-family: monospace;
            white-space: pre-wrap;
            word-wrap: break-word;
            margin: 10px 0;
        }
        .watermark-section {
            background: #e6f3ff;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #1890ff;
        }
        h1, h2, h3 {
            color: #333;
        }
        .info-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
        }
        .button {
            background: #1890ff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin: 5px;
        }
        .button:hover {
            background: #096dd9;
        }
        .copy-btn {
            background: #28a745;
        }
        .copy-btn:hover {
            background: #218838;
        }
        .video-info {
            background: #e9ecef;
            padding: 15px;
            border-radius: 8px;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Video Player & Embed Code</h1>
        
        <!-- Information Box -->
        <div class="info-box">
            <strong>Please note!</strong>
            <ul>
                <li>Only you can view this video in your browser because you uploaded it.</li>
                <li>If you want to share with others, please use the iframe embed code.</li>
                <li>Just copy the embed iframe code and embed it on your website.</li>
                <li>Please ensure that you have the legal permission to share this content.</li>
            </ul>
        </div>

        <!-- Video Information -->
        <div class="video-info">
            <h3>Video Information</h3>
            <p><strong>Filename:</strong> video-67d22730c39187.11863799.mp4</p>
            <p><strong>Slug:</strong> wXjo8noc1</p>
            <p><strong>Embed URL:</strong> https://short.icu/wXjo8noc1</p>
        </div>

        <!-- Embedded Video Player -->
        <div class="video-section">
            <h2>Your Video Preview</h2>
            <iframe 
                width="640" 
                height="360" 
                src="https://short.icu/wXjo8noc1" 
                frameborder="0" 
                scrolling="no" 
                allowfullscreen
                style="border-radius: 8px; box-shadow: 0 4px 15px rgba(0,0,0,0.2);">
            </iframe>
        </div>

        <!-- Embed Code Section -->
        <div class="embed-section">
            <h2>Embed Code</h2>
            <p>Copy and paste this code to embed the video on your website:</p>
            <div class="embed-code" id="embedCode">
&lt;iframe width="640" height="360" src="https://short.icu/wXjo8noc1" frameborder="0" scrolling="no" allowfullscreen&gt;&lt;/iframe&gt;
            </div>
            <button class="button copy-btn" onclick="copyEmbedCode()">Copy Embed Code</button>
            
            <h3 style="margin-top: 30px;">Alternative Sizes</h3>
            
            <div style="display: flex; gap: 10px; margin: 15px 0;">
                <button class="button" onclick="changeSize(640, 360)">640×360</button>
                <button class="button" onclick="changeSize(800, 450)">800×450</button>
                <button class="button" onclick="changeSize(960, 540)">960×540</button>
                <button class="button" onclick="changeSize(1280, 720)">1280×720</button>
            </div>
            
            <div class="embed-code" id="customEmbedCode">
&lt;iframe width="640" height="360" src="https://short.icu/wXjo8noc1" frameborder="0" scrolling="no" allowfullscreen&gt;&lt;/iframe&gt;
            </div>
            <button class="button copy-btn" onclick="copyCustomEmbedCode()">Copy Custom Size Code</button>
        </div>

        <!-- Watermark Section -->
        <div class="watermark-section">
            <h2>Custom Watermark Logo</h2>
            <p>Add a custom watermark to your video:</p>
            
            <div style="margin: 15px 0;">
                <label for="watermarkUpload">Upload Watermark Logo:</label>
                <input type="file" id="watermarkUpload" accept="image/*" style="margin: 10px 0;">
            </div>
            
            <div style="margin: 15px 0;">
                <label for="watermarkPosition">Watermark Position:</label>
                <select id="watermarkPosition" style="margin: 10px; padding: 5px;">
                    <option value="top-right">Top Right</option>
                    <option value="top-left">Top Left</option>
                    <option value="bottom-right">Bottom Right</option>
                    <option value="bottom-left">Bottom Left</option>
                    <option value="center">Center</option>
                </select>
            </div>
            
            <button class="button" onclick="previewWatermark()">Preview Watermark</button>
            <button class="button copy-btn" onclick="generateWatermarkCode()">Generate Watermark Code</button>
            
            <div id="watermarkPreview" style="margin-top: 20px; display: none;">
                <h4>Watermark Preview Code:</h4>
                <div class="embed-code" id="watermarkCode"></div>
            </div>
        </div>
    </div>

    <script>
        // Copy embed code to clipboard
        function copyEmbedCode() {
            const embedCode = document.getElementById('embedCode').textContent;
            copyToClipboard(embedCode);
            alert('Embed code copied to clipboard!');
        }

        // Copy custom embed code to clipboard
        function copyCustomEmbedCode() {
            const customCode = document.getElementById('customEmbedCode').textContent;
            copyToClipboard(customCode);
            alert('Custom embed code copied to clipboard!');
        }

        // Change iframe size
        function changeSize(width, height) {
            const iframe = document.querySelector('iframe');
            iframe.width = width;
            iframe.height = height;
            
            // Update custom embed code
            const customCode = `<iframe width="${width}" height="${height}" src="https://short.icu/wXjo8noc1" frameborder="0" scrolling="no" allowfullscreen></iframe>`;
            document.getElementById('customEmbedCode').textContent = customCode;
        }

        // Preview watermark
        function previewWatermark() {
            const fileInput = document.getElementById('watermarkUpload');
            const position = document.getElementById('watermarkPosition').value;
            
            if (fileInput.files.length === 0) {
                alert('Please select a watermark image first.');
                return;
            }
            
            alert('Watermark preview generated! Use "Generate Watermark Code" to get the embed code with watermark.');
        }

        // Generate watermark code
        function generateWatermarkCode() {
            const fileInput = document.getElementById('watermarkUpload');
            const position = document.getElementById('watermarkPosition').value;
            
            if (fileInput.files.length === 0) {
                alert('Please upload a watermark image first.');
                return;
            }
            
            // This would typically involve server-side processing
            // For demo purposes, we'll show a placeholder code
            const watermarkCode = `<!-- Watermark feature requires server-side implementation -->
<iframe width="640" height="360" src="https://short.icu/wXjo8noc1" frameborder="0" scrolling="no" allowfullscreen style="position: relative;">
    <!-- Custom watermark would be applied via CSS/JS or server processing -->
</iframe>
            
<!-- Note: Actual watermark implementation requires:
1. Server-side video processing, OR
2. Custom player with overlay, OR  
3. Platform-specific watermark features -->`;
            
            document.getElementById('watermarkCode').textContent = watermarkCode;
            document.getElementById('watermarkPreview').style.display = 'block';
        }

        // Utility function to copy to clipboard
        function copyToClipboard(text) {
            const textarea = document.createElement('textarea');
            textarea.value = text;
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand('copy');
            document.body.removeChild(textarea);
        }

        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Video embed page loaded');
            console.log('Video Slug: wXjo8noc1');
            console.log('Embed URL: https://short.icu/wXjo8noc1');
        });
    </script>
</body>
</html>