




<?php 
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} 
catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Connection failed: ' . $e->getMessage()]);
    exit;
}

// GET user_id
$top_user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

try {

    // =======================================
    // FINAL COMBINED LOGIC WITH SORTING
    // =======================================

    if ($top_user_id == 1) {

        // Admin → show ALL wallpapers
        $stmt = $connection->query("
            SELECT id, caption, file_url, media_type, category, user_id
            FROM wallpapers
            ORDER BY id ASC
        ");

    } else {

        // Normal user → show user wallpapers first, then user_id = 1 wallpapers
        $stmt = $connection->prepare("
            SELECT id, caption, file_url, media_type, category, user_id
            FROM wallpapers
            WHERE user_id = :uid OR user_id = 1
            ORDER BY (user_id = :uid) DESC, id ASC
        ");
        
        $stmt->execute(['uid' => $top_user_id]);
    }

    $wallpapers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'wallpapers' => $wallpapers
    ]);

} 
catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
