<?php
header('Content-Type: application/json');

// Database configuration
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    // Establish database connection
    $connection = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $connection->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

    // Validate input
    $parent_id = filter_input(INPUT_POST, 'parent_id', FILTER_VALIDATE_INT);
    
    if (!$parent_id || $parent_id <= 0) {
        throw new Exception('Valid parent comment ID is required');
    }

    // Prepare and execute query
    $sql = "SELECT 
                id,
                post_id,
                parent_id,
                username,
                comment,
                is_gif,
                gif_url,
                created_at,
                like_count,
                replies_count,
                parent_username,
                reels_video
            FROM commentse 
            WHERE parent_id = :parent_id 
            ORDER BY created_at ASC";
    
    $stmt = $connection->prepare($sql);
    $stmt->bindParam(':parent_id', $parent_id, PDO::PARAM_INT);
    $stmt->execute();

    // Fetch and format replies
    $replies = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Ensure consistent data types
    $formattedReplies = array_map(function($reply) {
        return [
            'id' => (int)$reply['id'],
            'post_id' => $reply['post_id'],
            'parent_id' => (int)$reply['parent_id'],
            'username' => $reply['username'],
            'comment' => $reply['comment'],
            'is_gif' => (int)$reply['is_gif'],
            'gif_url' => $reply['gif_url'],
            'created_at' => $reply['created_at'],
            'like_count' => (int)$reply['like_count'],
            'replies_count' => (int)$reply['replies_count'],
            'parent_username' => $reply['parent_username'],
            'reels_video' => $reply['reels_video'],
            'isLiked' => false, // Default value, can be updated by client
            'likeCount' => (int)$reply['like_count'] // Alias for like_count
        ];
    }, $replies);

    // Return success response
    echo json_encode([
        'status' => 'success',
        'replies' => $formattedReplies
    ]);

} catch (PDOException $e) {
    // Database error
    error_log('Database error: ' . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error occurred'
    ]);
} catch (Exception $e) {
    // General error
    error_log('Error in reply.php: ' . $e->getMessage());
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>