

<?php
header('Content-Type: application/json');

// Database connection
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get POST data
    $post_id = $_POST['post_id'] ?? null;
    $username = $_POST['username'] ?? null;
    $comment = $_POST['comment'] ?? '';
    $gif_url = $_POST['gif_url'] ?? null;
    $is_gif = $_POST['is_gif'] ?? 0;
    $parent_id = $_POST['parent_id'] ?? null;

    if (!$post_id || !$username) {
        throw new Exception('Missing required fields');
    }

    // Start transaction
    $connection->beginTransaction();

    // Insert the comment
    $sql = "INSERT INTO commentse (post_id, parent_id, username, comment, is_gif, gif_url) 
            VALUES (:post_id, :parent_id, :username, :comment, :is_gif, :gif_url)";
    $stmt = $connection->prepare($sql);

    $stmt->bindParam(':post_id', $post_id);
    $stmt->bindParam(':parent_id', $parent_id);
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':comment', $comment);
    $stmt->bindParam(':is_gif', $is_gif);
    $stmt->bindParam(':gif_url', $gif_url);

    if (!$stmt->execute()) {
        throw new Exception('Failed to execute query');
    }

    // If this is a reply, update the parent's replies count
    if ($parent_id) {
        $updateSql = "UPDATE commentse SET replies_count = replies_count + 1 WHERE id = :parent_id";
        $updateStmt = $connection->prepare($updateSql);
        $updateStmt->bindParam(':parent_id', $parent_id);
        if (!$updateStmt->execute()) {
            throw new Exception('Failed to update parent comment');
        }
    }

    $connection->commit();

    echo json_encode([
        'status' => 'success',
        'message' => 'Comment posted successfully'
    ]);
} catch (PDOException $e) {
    $connection->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    $connection->rollBack();
    echo json_encode([
        'status' => 'error',
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>