<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

$base_url = 'uploads/'; // Change to your domain
$upload_dir = 'uploads/';

header('Content-Type: application/json');

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

if (isset($_FILES['my_video'], $_POST['user_id'], $_POST['caption'])) {
    $video_name = $_FILES['my_video']['name'];
    $video_tmp = $_FILES['my_video']['tmp_name'];
    $video_error = $_FILES['my_video']['error'];

    $user_id = $_POST['user_id'];
    $caption = $_POST['caption'];
    $category = $_POST['category'] ?? 'General';
    $hastag = $_POST['Hastag'] ?? 'General';
    $tagged_friends = isset($_POST['tagged_friends']) ? json_decode($_POST['tagged_friends'], true) : [];

    $thumb_url = null;

    if ($video_error === 0) {
        $video_ext = strtolower(pathinfo($video_name, PATHINFO_EXTENSION));
        $allowed_exts = ['mp4', 'webm', 'avi', 'flv'];

        if (!in_array($video_ext, $allowed_exts)) {
            echo json_encode(['success' => false, 'error' => 'Invalid file type.']);
            exit;
        }

        $new_video_name = uniqid("video-", true) . '.' . $video_ext;
        $video_path = $upload_dir . $new_video_name;

        if (!move_uploaded_file($video_tmp, $video_path)) {
            echo json_encode(['success' => false, 'error' => 'Failed to move uploaded video.']);
            exit;
        }

        $video_url = $base_url . $new_video_name;

        // ✅ Handle thumbnail
        if (isset($_FILES['thumbnail']) && $_FILES['thumbnail']['error'] === 0) {
            $thumb_ext = pathinfo($_FILES['thumbnail']['name'], PATHINFO_EXTENSION);
            $thumb_name = uniqid("thumb-", true) . '.' . $thumb_ext;
            $thumb_path = $upload_dir . $thumb_name;

            if (move_uploaded_file($_FILES['thumbnail']['tmp_name'], $thumb_path)) {
                $thumb_url = $base_url . $thumb_name;
            }
        }

        try {
            $connection->beginTransaction();

            // Insert into main video table
            $stmt = $connection->prepare("
                INSERT INTO reels_videose 
                (caption, reels_video, media_type, user_id, category, Hastag, thumbnail) 
                VALUES 
                (:caption, :reels_video, :media_type, :user_id, :category, :hastag, :thumbnail)
            ");

            $stmt->execute([
                ':caption' => $caption,
                ':reels_video' => $video_url,
                ':media_type' => 'video',
                ':user_id' => $user_id,
                ':category' => $category,
                ':hastag' => $hastag,
                ':thumbnail' => $thumb_url
            ]);

            $post_id = $connection->lastInsertId();

            // Optional: Insert tagged friends
            if (!empty($tagged_friends)) {
                $tagStmt = $connection->prepare("
                    INSERT INTO tagged_friends_reels_videose (post_id, user_id)
                    VALUES (:post_id, :friend_id)
                ");
                foreach ($tagged_friends as $friend_id) {
                    if (!empty($friend_id)) {
                        $tagStmt->execute([
                            ':post_id' => $post_id,
                            ':friend_id' => $friend_id
                        ]);
                    }
                }
            }

            $connection->commit();

            echo json_encode([
                'success' => true,
                'post_id' => $post_id,
                'video_url' => $video_url,
                'thumbnail_url' => $thumb_url
            ]);
        } catch (PDOException $e) {
            $connection->rollBack();
            echo json_encode(['success' => false, 'error' => $e->getMessage()]);
        }

    } else {
        echo json_encode(['success' => false, 'error' => 'Error uploading video.']);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Missing required fields (video, user_id, caption).']);
}
?>
