


<?php
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Connection failed: ' . $e->getMessage()]);
    exit;
}

// Check required fields
if (isset($_POST['caption'], $_FILES['my_image'], $_POST['user_id'])) {
    $caption = trim($_POST['caption']);
    $user_id = (int)$_POST['user_id'];
    $hastag = isset($_POST['Hastag']) ? trim($_POST['Hastag']) : 'General';
    $category = isset($_POST['category']) ? trim($_POST['category']) : 'General';
    $tagged_friends = isset($_POST['tagged_friends']) ? json_decode($_POST['tagged_friends'], true) : [];

    // ==============================================
    // 🎵 MUSIC UPLOAD HANDLING
    // ==============================================
    $music_url = null;
    
    // Check if music file is uploaded
    if (isset($_FILES['music']) && $_FILES['music']['error'] === UPLOAD_ERR_OK) {
        $music_file = $_FILES['music'];
        
        // Validate music file
        $allowed_music_types = ['audio/mpeg', 'audio/mp3', 'audio/m4a', 'audio/wav', 'audio/ogg'];
        $max_music_size = 20 * 1024 * 1024; // 20MB
        
        // Check file size
        if ($music_file['size'] > $max_music_size) {
            echo json_encode(['success' => false, 'error' => 'Music file too large. Maximum size: 20MB']);
            exit;
        }
        
        // Generate unique filename
        $music_ext = strtolower(pathinfo($music_file['name'], PATHINFO_EXTENSION));
        if (empty($music_ext)) {
            $music_ext = 'mp3'; // Default extension
        }
        
        $music_filename = uniqid("music_", true) . '.' . $music_ext;
        $music_url = 'uploads/' . $music_filename;
        
        // Move uploaded music file
        if (!move_uploaded_file($music_file['tmp_name'], $music_url)) {
            error_log("Failed to move music file");
            $music_url = null;
        } else {
            error_log("Music file uploaded: $music_url");
        }
    }
    
    // ==============================================
    // 📷 MEDIA FILE UPLOAD
    // ==============================================
    
    // Handle main media file upload
    $file_ex = strtolower(pathinfo($_FILES['my_image']['name'], PATHINFO_EXTENSION));
    $allowed_exs = ["jpg", "jpeg", "png", "gif", "mp4", "mov"];
    
    if (!in_array($file_ex, $allowed_exs)) {
        echo json_encode(['success' => false, 'error' => 'Invalid file type']);
        exit;
    }

    $new_file_name = uniqid("media-", true) . '.' . $file_ex;
    $file_upload_path = 'uploads/' . $new_file_name;

    if (!move_uploaded_file($_FILES['my_image']['tmp_name'], $file_upload_path)) {
        echo json_encode(['success' => false, 'error' => 'Failed to move uploaded file']);
        exit;
    }

    $media_type = in_array($file_ex, ["mp4", "mov"]) ? "video" : "image";
    $thumbnail = ($media_type === 'video') ? 'uploads/thumb_' . pathinfo($new_file_name, PATHINFO_FILENAME) . '.jpg' : null;

    // ==============================================
    // 💾 DATABASE OPERATIONS
    // ==============================================
    
    try {
        $connection->beginTransaction();

        // Insert main post with CORRECT COLUMN ORDER
        $stmt = $connection->prepare(
            "INSERT INTO reels_videose (caption, music_url, reels_video, user_id, media_type, Hastag, category, thumbnail)
             VALUES (?, ?, ?, ?, ?, ?, ?, ?)"
        );
        $stmt->execute([$caption, $music_url, $file_upload_path, $user_id, $media_type, $hastag, $category, $thumbnail]);
        $post_id = $connection->lastInsertId();

        // Insert tagged friends if any
        if (!empty($tagged_friends)) {
            $tagStmt = $connection->prepare(
                "INSERT INTO tagged_friends_reels_video (post_id, user_id) VALUES (?, ?)"
            );
            foreach ($tagged_friends as $friend_id) {
                try {
                    $tagStmt->execute([$post_id, $friend_id]);
                } catch (PDOException $e) {
                    if ($e->getCode() != 23000) throw $e;
                }
            }
        }

        $connection->commit();

        // Success response
        $response = [
            'success' => true,
            'post_id' => $post_id,
            'tagged_count' => count($tagged_friends),
            'media_url' => $file_upload_path,
            'thumbnail' => $thumbnail,
            'music_url' => $music_url,
            'media_type' => $media_type,
            'user_id' => $user_id
        ];
        
        error_log("Upload successful - Post ID: $post_id, Music: " . ($music_url ?: 'none'));
        
        echo json_encode($response);
        
    } catch (PDOException $e) {
        $connection->rollBack();
        
        // Clean up uploaded files on error
        if (file_exists($file_upload_path)) unlink($file_upload_path);
        if ($music_url && file_exists($music_url)) unlink($music_url);
        
        echo json_encode(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'error' => 'Required fields missing']);
}
?>