
<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Database configuration
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "dreams";

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    http_response_code(500);
    die(json_encode([
        'status' => 'error',
        'message' => 'Connection failed: ' . $conn->connect_error
    ]));
}

// Check if files were uploaded
if (!isset($_FILES['image1']) || !isset($_FILES['image2'])) {
    http_response_code(400);
    die(json_encode([
        'status' => 'error',
        'message' => 'Both images are required'
    ]));
}

// Define upload directory
$uploadDir = 'uploads/';
if (!file_exists($uploadDir)) {
    if (!mkdir($uploadDir, 0777, true)) {
        http_response_code(500);
        die(json_encode([
            'status' => 'error',
            'message' => 'Failed to create upload directory'
        ]));
    }
}

// Generate a clean filename in the format: image-random.extension
function createSafeFilename($file) {
    // Get the original file extension
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mime = $finfo->file($file['tmp_name']);
    
    // Map MIME type to extension
    $extensions = [
        'image/jpeg' => 'jpg',
        'image/png' => 'png',
        'image/gif' => 'gif',
        'image/webp' => 'webp',
        'image/avif' => 'avif'
    ];
    
    $extension = $extensions[$mime] ?? 'jpg'; // Default to jpg if unknown
    
    // Generate random parts
    $randomPart1 = bin2hex(random_bytes(8)); // 16 chars
    $randomPart2 = bin2hex(random_bytes(4)); // 8 chars
    
    return "image-{$randomPart1}.{$randomPart2}.{$extension}";
}

// Process image 1
$image1 = $_FILES['image1'];
$image1Name = createSafeFilename($image1);
$image1Path = $uploadDir . $image1Name;

// Process image 2
$image2 = $_FILES['image2'];
$image2Name = createSafeFilename($image2);
$image2Path = $uploadDir . $image2Name;

// Move files
if (!move_uploaded_file($image1['tmp_name'], $image1Path)) {
    http_response_code(500);
    die(json_encode([
        'status' => 'error',
        'message' => 'Failed to move image1'
    ]));
}

if (!move_uploaded_file($image2['tmp_name'], $image2Path)) {
    unlink($image1Path); // rollback
    http_response_code(500);
    die(json_encode([
        'status' => 'error',
        'message' => 'Failed to move image2'
    ]));
}

// Insert into DB
$stmt = $conn->prepare("INSERT INTO uploads (image1_path, image2_path) VALUES (?, ?)");
if (!$stmt) {
    http_response_code(500);
    die(json_encode([
        'status' => 'error',
        'message' => 'Prepare failed: ' . $conn->error
    ]));
}

$stmt->bind_param("ss", $image1Path, $image2Path);
if (!$stmt->execute()) {
    http_response_code(500);
    die(json_encode([
        'status' => 'error',
        'message' => 'Execute failed: ' . $stmt->error
    ]));
}

$insertedId = $stmt->insert_id;

$stmt->close();
$conn->close();

http_response_code(200);
echo json_encode([
    'status' => 'success',
    'message' => 'Images uploaded successfully',
    'id' => $insertedId,
    'image1_path' => $image1Path,
    'image2_path' => $image2Path
]);
?>