<?php
$response = [];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $sender_id = $_POST['sender_id'] ?? null;
    $receiver_id = $_POST['receiver_id'] ?? null;
    $post_id = $_POST['post_id'] ?? null;
    $file_types = $_POST['file_types'] ?? null;
    $message = $_POST['message'] ?? null;

    if (!$sender_id || !$receiver_id) {
        $response['error'] = "Missing sender or receiver ID.";
        echo json_encode($response);
        exit;
    }

    $conn = new mysqli("localhost", "root", "", "dreams");
    if ($conn->connect_error) {
        $response['error'] = "Database connection failed.";
        echo json_encode($response);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO messages (sender_id, receiver_id, message, post_id, file_types, status, is_read) VALUES (?, ?, ?, ?, ?, 'sent', 0)");
    $stmt->bind_param("iisss", $sender_id, $receiver_id, $message, $post_id, $file_types);

    if ($stmt->execute()) {
        $response['success'] = true;
    } else {
        $response['error'] = "Database insert failed: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
    echo json_encode($response);
}
?>
