
<?php
include "db_conn.php";

// Get the user_id from the query parameters
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

// Prepare the SQL statement to get only images
$sql = "SELECT 
            rv.id, 
            rv.reels_video, 
            rv.caption, 
            rv.music_url, 
            rv.created_at, 
            (SELECT COUNT(*) FROM likese l WHERE l.post_id = rv.id) as like_count 
        FROM 
            reels_videose rv 
        WHERE 
            rv.user_id = ? 
            AND rv.media_type = 'image'
        ORDER BY 
            rv.id DESC";

$stmt = mysqli_prepare($conn, $sql);

if ($stmt) {
    // Bind the user_id parameter
    mysqli_stmt_bind_param($stmt, 'i', $user_id);

    // Execute the statement
    mysqli_stmt_execute($stmt);

    // Get the result
    $res = mysqli_stmt_get_result($stmt);

    $videoUrls = array();
    $baseUrl = "http://10.91.25.51/dreams/";

    // Check if there are results
    if (mysqli_num_rows($res) > 0) {
        while ($video = mysqli_fetch_assoc($res)) {
            $videoUrls[] = array(
                'id' => $video['id'],
                'url' => $baseUrl . $video['reels_video'],
                'caption' => $video['caption'],
                'created_at' => $video['created_at'],
                'like_count' => $video['like_count'],
                'music_url' => $video['music_url'] ,
            );
        }
    }

    // Count the number of images
    $videoCount = count($videoUrls);

    // Prepare the response
    $response = array(
        'count' => $videoCount,
        'videos' => $videoUrls
    );

    // Return the JSON response
    echo json_encode($response);
} else {
    echo json_encode(["error" => "Failed to prepare the SQL statement."]);
}

// Close the statement
mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
