


<?php
// Base URL for media files
$base_url = "http://10.190.187.51/dreams/";

// Connect to MySQL database
$conn = new mysqli("localhost", "root", "", "dreams");

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

// Function to check if a user is a follower of another user
function is_follower($user_id, $follow_id, $conn) {
    $stmt = $conn->prepare("SELECT * FROM follows WHERE user_id = ? AND follow_id = ?");
    $stmt->bind_param("ii", $user_id, $follow_id);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->num_rows > 0;
}

// Function to get like count for a post
function get_like_count($post_id, $conn) {
    $stmt = $conn->prepare("SELECT COUNT(*) as like_count FROM likes WHERE post_id = ?");
    $stmt->bind_param("i", $post_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    return $row['like_count'];
}

// Function to fetch reels with like counts and add base URL
function fetch_reels_with_likes($user_id, $conn, $base_url) {
    $stmt = $conn->prepare("SELECT * FROM reels_video WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $account_content = array();
    
    while ($row = $result->fetch_assoc()) {
        $post_id = $row['id'];
        $row['like_count'] = get_like_count($post_id, $conn);
        
        // Add base URL to reels_video if it exists
        if (!empty($row['reels_video'])) {
            $row['reels_video'] = $base_url . $row['reels_video'];
        }
        
        // Add base URL to thumbnail if it exists
        if (!empty($row['thumbnail'])) {
            $row['thumbnail'] = $base_url . $row['thumbnail'];
        }
        
        $account_content[] = $row;
    }
    
    return $account_content;
}

// Function to get account content for a user
function get_account_content($user_id, $viewer_id, $conn, $base_url) {
    $stmt = $conn->prepare("SELECT is_private FROM login WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 0) {
        return ["message" => "User not found."];
    }
    
    $row = $result->fetch_assoc();
    $is_private = $row['is_private'];

    if ($is_private == 1) {
        if (is_follower($viewer_id, $user_id, $conn)) {
            return fetch_reels_with_likes($user_id, $conn, $base_url);
        } else {
            return ["message" => "This account is private."];
        }
    } else {
        return fetch_reels_with_likes($user_id, $conn, $base_url);
    }
}

// Check if the request method is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    header('Content-Type: application/json');
    
    // Check if the user_id and viewer_id are set
    if (isset($_POST["user_id"]) && isset($_POST["viewer_id"])) {
        $user_id = (int)$_POST["user_id"];
        $viewer_id = (int)$_POST["viewer_id"];
        
        $account_content = get_account_content($user_id, $viewer_id, $conn, $base_url);
        echo json_encode($account_content);
    } else {
        echo json_encode(["message" => "User ID and Viewer ID are required."]);
    }
} else {
    header('Content-Type: application/json');
    echo json_encode(["message" => "Invalid request method."]);
}

$conn->close();
?>