<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
// Database configuration
$host = 'localhost'; // Your database host
$dbname = 'dreams'; // Your database name
$username = 'root'; // Your database username
$password = ''; // Your database password

try {
    // Create a new PDO instance
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    // Set the PDO error mode to exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if user_id is provided in the URL
    if (isset($_GET['user_id'])) {
        $user_id = intval($_GET['user_id']); // Get user_id from URL and convert to integer

        // SQL query to count all entries in the reels_video table for the specified user_id
        $sql = "SELECT COUNT(*) AS total_videos FROM reels_video WHERE user_id = :user_id";
        
        // Prepare the statement
        $stmt = $pdo->prepare($sql);
        
        // Bind the user_id parameter
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        
        // Execute the statement
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Display the count
      echo " " . $result['total_videos'];
    } else {
        echo "Error: user_id parameter is missing.";
    }

} catch (PDOException $e) {
    // Handle any errors
    echo "Error: " . $e->getMessage();
}

// Close the connection
$pdo = null;
?>