

<?php
header('Content-Type: application/json; charset=utf-8');

// Database connection
$host = "localhost";
$user = "root";
$pass = "";
$dbname = "dreams";

$conn = new mysqli($host, $user, $pass, $dbname);
if ($conn->connect_error) {
    echo json_encode(["status" => "error", "message" => "DB Connection Failed", "error" => $conn->connect_error]);
    exit;
}

// read POST
$username = isset($_POST['username']) ? trim($_POST['username']) : null;
$user_id_post = isset($_POST['user_id']) ? intval($_POST['user_id']) : null;
$follow_id = isset($_POST['follow_id']) ? intval($_POST['follow_id']) : 0;

if ($follow_id == 0) {
    echo json_encode(["status" => "error", "message" => "follow_id missing or invalid"]);
    exit;
}

// Determine current user id
if ($user_id_post && $user_id_post > 0) {
    $user_id = $user_id_post;
} elseif (!empty($username)) {
    $safe_username = $conn->real_escape_string($username);
    $res = $conn->query("SELECT id FROM login WHERE username = '$safe_username' LIMIT 1");
    if (!$res) {
        echo json_encode(["status" => "error", "message" => "Query failed", "error" => $conn->error]);
        exit;
    }
    if ($res->num_rows == 0) {
        echo json_encode(["status" => "error", "message" => "User not found for given username"]);
        exit;
    }
    $row = $res->fetch_assoc();
    $user_id = intval($row['id']);
} else {
    echo json_encode(["status" => "error", "message" => "No user identifier provided"]);
    exit;
}

// Check follow target exists
$res2 = $conn->query("SELECT id FROM login WHERE id = {$follow_id} LIMIT 1");
if (!$res2 || $res2->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Follow target not found"]);
    exit;
}

// Prevent following self
if ($user_id === $follow_id) {
    echo json_encode(["status" => "error", "message" => "Cannot follow yourself"]);
    exit;
}

// Check already exists
$res3 = $conn->query("SELECT id FROM follows WHERE user_id = {$user_id} AND follow_id = {$follow_id} LIMIT 1");
if ($res3 && $res3->num_rows > 0) {
    echo json_encode(["status" => "error", "message" => "Already following"]);
    exit;
}

// Insert
$stmt = $conn->prepare("INSERT INTO follows (user_id, follow_id) VALUES (?, ?)");
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Prepare failed", "error" => $conn->error]);
    exit;
}
$stmt->bind_param("ii", $user_id, $follow_id);
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Followed successfully", "user_id" => $user_id, "follow_id" => $follow_id]);
} else {
    echo json_encode(["status" => "error", "message" => "Insert failed", "error" => $stmt->error]);
}
$stmt->close();
$conn->close();
?>
