<?php
$servername = "localhost"; // Your database server
$username = "root"; // Your database username
$password = ""; // Your database password
$dbname = "dreams"; // Your database name

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]));
}

// Get the ID from the request
$id = isset($_POST['id']) ? intval($_POST['id']) : 0;

// Check if ID is valid
if ($id > 0) {
    // Prepare and bind
    $stmt = $conn->prepare("DELETE FROM video WHERE id = ?");
    $stmt->bind_param("i", $id);

    // Execute the statement
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(["success" => true, "message" => "Record deleted successfully."]);
        } else {
            echo json_encode(["success" => false, "message" => "No record found with the provided ID."]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Error deleting record: " . $stmt->error]);
    }

    // Close the statement
    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid ID provided."]);
}

// Close the connection
$conn->close();
?>