





<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

// DB connect
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "chat_bot";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die(json_encode(["success" => false, "message" => "Connection failed"]));
}

// Read POST body
$data = json_decode(file_get_contents("php://input"), true);

$user_id = $data['user_id'] ?? null;
$responses = $data['responses'] ?? [];

if (!$user_id || empty($responses)) {
    echo json_encode(["success" => false, "message" => "Invalid input"]);
    exit;
}

// ✅ Delete old records for this user_id
$conn->query("DELETE FROM user_responses WHERE user_id = '$user_id'");

// ✅ Insert new records
$stmt = $conn->prepare("INSERT INTO user_responses (user_id, category, response_text) VALUES (?, ?, ?)");

foreach ($responses as $row) {
    $category = $row['category'];
    $response_text = $row['response_text'];
    $stmt->bind_param("iss", $user_id, $category, $response_text);
    $stmt->execute();
}

echo json_encode(["success" => true, "message" => "Responses saved for user $user_id"]);
?>

