


<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
session_start();

// Database connection
$conn = new mysqli('localhost', 'root', '', 'chat_bot');
if ($conn->connect_error) {
    die(json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]));
}

// Get input
$input = json_decode(file_get_contents("php://input"));
if (!$input || !isset($input->message) || !isset($input->user_id)) {
    die(json_encode(['error' => 'Invalid request data']));
}

$userMessage = trim($input->message);
$userId = $conn->real_escape_string($input->user_id);
$otherUserId = isset($input->other_user_id) ? $conn->real_escape_string($input->other_user_id) : null;
$isLocationRequest = isset($input->is_location_request) && $input->is_location_request;

// Check user permissions for all requests
if ($otherUserId !== null) {
    $allowCheck = $conn->query("SELECT * FROM user_allow WHERE user_id = '$userId' AND other_user_id = '$otherUserId' AND allowed = 1");
    
    if ($allowCheck->num_rows == 0) {
        die(json_encode(['error' => 'Communication not allowed between these users']));
    }
}

// Location sharing check
if ($isLocationRequest) {
    if (!isset($input->other_user_id)) {
        die(json_encode(['error' => 'other_user_id is required for location sharing']));
    }

    // Check location-specific permission
    $locationAllowCheck = $conn->query("SELECT * FROM user_allow WHERE user_id = '$userId' AND other_user_id = '$otherUserId' AND location_allowed = 1");
    if ($locationAllowCheck->num_rows == 0) {
        die(json_encode(['error' => 'Location sharing not allowed between these users']));
    }

    $stmt = $conn->prepare("SELECT * FROM location_sharing WHERE user_id = ? AND other_user_id = ? AND sharing_allowed = 1");
    $stmt->bind_param("ss", $userId, $otherUserId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $locationStmt = $conn->prepare("SELECT latitude, longitude FROM locations WHERE user_id = ?");
        $locationStmt->bind_param("s", $otherUserId);
        $locationStmt->execute();
        $locationResult = $locationStmt->get_result();

        if ($locationResult->num_rows > 0) {
            $location = $locationResult->fetch_assoc();
            echo json_encode([
                "response" => "Here's my current location:",
                "isLocationShared" => true,
                "latitude" => (float)$location['latitude'],
                "longitude" => (float)$location['longitude']
            ]);
        } else {
            echo json_encode([
                "response" => "Location not available.",
                "isLocationShared" => false
            ]);
        }

        $locationStmt->close();
    } else {
        echo json_encode([
            "response" => "Location sharing is not enabled.",
            "isLocationShared" => false
        ]);
    }

    $stmt->close();
    $conn->close();
    exit;
}

// Naive Bayes Classifier
class NaiveBayesClassifier {
    private $wordCounts = [];
    private $categoryCounts = [];
    private $vocabulary = [];
    private $totalDocuments = 0;

    public function train($documents, $categories) {
        $this->totalDocuments = count($documents);
        foreach (array_unique($categories) as $category) {
            $this->categoryCounts[$category] = 0;
            $this->wordCounts[$category] = [];
        }

        for ($i = 0; $i < $this->totalDocuments; $i++) {
            $category = $categories[$i];
            $this->categoryCounts[$category]++;
            $words = $this->tokenize($documents[$i]);
            foreach ($words as $word) {
                if (!isset($this->wordCounts[$category][$word])) {
                    $this->wordCounts[$category][$word] = 0;
                }
                $this->wordCounts[$category][$word]++;
                $this->vocabulary[$word] = true;
            }
        }
    }

    public function predict($document) {
        $words = $this->tokenize($document);
        $bestCategory = null;
        $maxScore = -INF;

        foreach ($this->categoryCounts as $category => $count) {
            $score = $this->calculateCategoryScore($words, $category);
            if ($score > $maxScore) {
                $maxScore = $score;
                $bestCategory = $category;
            }
        }

        return $bestCategory;
    }

    private function calculateCategoryScore($words, $category) {
        $totalCategories = array_sum($this->categoryCounts);
        $score = log($this->categoryCounts[$category] / $totalCategories);

        $totalWordsInCategory = array_sum($this->wordCounts[$category]);
        $vocabularySize = count($this->vocabulary);

        foreach ($words as $word) {
            $wordCount = $this->wordCounts[$category][$word] ?? 0;
            $score += log(($wordCount + 1) / ($totalWordsInCategory + $vocabularySize));
        }

        return $score;
    }

    private function tokenize($text) {
        $text = strtolower($text);
        $text = preg_replace('/[^a-z0-9\s]/', '', $text);
        return preg_split('/\s+/', $text, -1, PREG_SPLIT_NO_EMPTY);
    }
}

// Fuzzy Matcher
class FuzzyMatcher {
    public static function findBestMatch($input, $patterns, $threshold = 2) {
        $input = strtolower(trim($input));
        $bestMatch = null;
        $bestDistance = PHP_INT_MAX;

        foreach (explode(',', $patterns) as $pattern) {
            $pattern = trim($pattern);
            $distance = levenshtein($input, $pattern);
            if ($distance < $bestDistance && $distance <= $threshold) {
                $bestDistance = $distance;
                $bestMatch = $pattern;
            }
        }

        return $bestMatch;
    }
}

// Conversation limit check
$countResult = $conn->query("SELECT message_count FROM user_conversations WHERE user_id = '$userId'");
$currentCount = ($countResult && $countResult->num_rows > 0)
    ? (int)$countResult->fetch_assoc()['message_count']
    : 0;

if ($currentCount === 0) {
    $conn->query("INSERT INTO user_conversations (user_id, message_count) VALUES ('$userId', 0)");
}

// Track category frequency for all categories
$categoryFrequencyResult = $conn->query("SELECT frequency FROM category_frequency WHERE user_id = '$userId'");
$categoryFrequency = ($categoryFrequencyResult && $categoryFrequencyResult->num_rows > 0)
    ? (int)$categoryFrequencyResult->fetch_assoc()['frequency'] + 1
    : 1;

$conn->query($categoryFrequencyResult && $categoryFrequencyResult->num_rows > 0
    ? "UPDATE category_frequency SET frequency = frequency + 1 WHERE user_id = '$userId'"
    : "INSERT INTO category_frequency (user_id, frequency) VALUES ('$userId', 1)");

if ($currentCount >= 5) {
    echo json_encode(['response' => '']);
    $conn->close();
    exit;
}

$newCount = $currentCount + 1;
$conn->query("UPDATE user_conversations SET message_count = $newCount WHERE user_id = '$userId'");

if ($newCount == 5) {
    echo json_encode(['response' => 'ok bye']);
    $conn->close();
    exit;
}

// Classify with Naive Bayes
$trainingData = $conn->query("SELECT message, category FROM training_data");
$documents = [];
$categories = [];

while ($row = $trainingData->fetch_assoc()) {
    $documents[] = $row['message'];
    $categories[] = $row['category'];
}

$classifier = new NaiveBayesClassifier();
$classifier->train($documents, $categories);

// Get the predicted category
$category = $classifier->predict($userMessage);
$baseCategory = preg_replace('/[0-9]+$/', '', $category);

// For ALL categories, use frequency-based responses
$responseCategory = match(min($categoryFrequency, 3)) {
    2 => $baseCategory . '2',
    3 => $baseCategory . '3',
    default => $baseCategory . '1'
};

// Check for user-specific response first
$userResponse = $conn->query("
    SELECT response_text FROM user_responses 
    WHERE user_id = '$userId' AND category = '$responseCategory' 
    LIMIT 1
");

if ($userResponse->num_rows > 0) {
    echo json_encode(['response' => $userResponse->fetch_assoc()['response_text']]);
    $conn->close();
    exit;
}

// Fallback to default response
$response = $conn->query("SELECT response_text FROM responses WHERE category = '$responseCategory' LIMIT 1");

if ($response->num_rows > 0) {
    echo json_encode(['response' => $response->fetch_assoc()['response_text']]);
    $conn->close();
    exit;
}

// If no numbered response found, try the base category
$fallbackResponse = $conn->query("SELECT response_text FROM responses WHERE category = '$baseCategory' LIMIT 1");

echo json_encode([
    'response' => $fallbackResponse->num_rows > 0
        ? $fallbackResponse->fetch_assoc()['response_text']
        : 'I\'m not sure how to respond to that.'
]);

$conn->close();
?>