
<?php
// Database connection settings
$host = 'localhost';
$dbname = 'dreams';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $user_id = $_GET['user_id'] ?? 0;

    // Step 1: Get username from login
    $stmtUser = $pdo->prepare("SELECT username FROM login WHERE id = :user_id");
    $stmtUser->bindParam(':user_id', $user_id, PDO::PARAM_INT);
    $stmtUser->execute();
    $user = $stmtUser->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode([]);
        exit;
    }

    $username = $user['username'];

    // Step 2: Get last 10 watched videos
    $sqlLastWatched = "
        SELECT vw.video_id, rv.category
        FROM video_watches vw
        JOIN reels_videose rv ON vw.video_id = rv.id
        WHERE vw.username = :username
        ORDER BY vw.watch_date DESC
        LIMIT 10
    ";
    $stmtLastWatched = $pdo->prepare($sqlLastWatched);
    $stmtLastWatched->bindParam(':username', $username, PDO::PARAM_STR);
    $stmtLastWatched->execute();
    $lastWatched = $stmtLastWatched->fetchAll(PDO::FETCH_ASSOC);

    // Step 3: Find top category
    $topCategory = null;
    if (!empty($lastWatched)) {
        $categoryCount = [];
        foreach ($lastWatched as $row) {
            $cat = $row['category'] ?: 'General';
            $categoryCount[$cat] = ($categoryCount[$cat] ?? 0) + 1;
        }
        arsort($categoryCount);
        $topCategory = array_key_first($categoryCount);
    }

    // Step 4: Get all unwatched videos, only media_type = 'video'
    $sql = "
        SELECT 
            rv.id,
            rv.created_at,
            rv.caption,
            rv.reels_video,
            rv.user_id,
            l.username,
            l.name,
            l.caption AS user_caption,
            l.reels_video AS user_reels_video,
            COUNT(lk.id) AS like_count
        FROM reels_videose rv
        LEFT JOIN login l ON rv.user_id = l.id
        LEFT JOIN likese lk ON rv.id = lk.post_id
        WHERE rv.media_type = 'video'
          AND rv.id NOT IN (
              SELECT video_id FROM video_watches WHERE username = :username
          )
        GROUP BY rv.id, l.username, l.name, l.caption, l.reels_video
        ORDER BY 
            CASE WHEN rv.category = :topCategory THEN 0 ELSE 1 END,
            rv.id DESC
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt->bindParam(':topCategory', $topCategory, PDO::PARAM_STR);
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Step 5: Add base URL to file paths

    $base_url = 'http://10.91.25.51/dreams/';

    foreach ($results as &$result) {
        if (!empty($result['reels_video'])) {
            $result['reels_video'] = $base_url . $result['reels_video'];
        }
        if (!empty($result['user_reels_video'])) {
            $result['user_reels_video'] = $base_url . $result['user_reels_video'];
        }
    }
    unset($result);

    // Output only videos array
    header('Content-Type: application/json');
    echo json_encode($results);

} catch (PDOException $e) {
    echo json_encode([]);
}
?>
