<?php
include "db_conn.php";

// Modify the SQL query to select a random video along with the username and like count
$sql = "SELECT rv.reels_video,rv.id, rv.user_id, rv.caption AS video_caption, rv.created_at, 
               l.username, l.name, l.reels_video AS image, l.caption AS user_caption,
               COUNT(ly.id) AS like_count
        FROM reels_video rv 
        LEFT JOIN login l ON rv.user_id = l.id 
        LEFT JOIN likes ly ON rv.id = ly.post_id 
        GROUP BY rv.id
        ORDER BY RAND() LIMIT 1";

$res = mysqli_query($conn, $sql);

$imageUrls = array();

if (mysqli_num_rows($res) > 0) {
    // Fetch the single random result
    $image = mysqli_fetch_assoc($res);
    // Include user_id and username in the response
    $imageUrls[] = [
        'reels_video' => $image['reels_video'],
        'user_id' => $image['user_id'],
        'username' => $image['username'],
        'video_caption' => $image['video_caption'],
        'created_at' => $image['created_at'],
        'name' => $image['name'],
        'image' => $image['image'],
        'user_caption' => $image['user_caption'],
        'like_count' => (int)$image['like_count'], // Cast to integer for JSON response
         'id' => $image['id'],
    ];
} else {
    echo json_encode(["error" => "Empty"]);
    exit;
}

// Return the single random video URL, user ID, username, captions, like count, and created_at as a JSON response
echo json_encode($imageUrls);
?>