<?php
include "db_conn.php";

// Modify the SQL query to select a random video along with the username and like count
$sql = "SELECT rv.reels_video, rv.id, rv.user_id, rv.caption AS video_caption, rv.created_at, 
               l.username, l.name, l.reels_video AS image, l.caption AS user_caption,
               COUNT(ly.id) AS like_count
        FROM reels_video rv 
        LEFT JOIN login l ON rv.user_id = l.id 
        LEFT JOIN likes ly ON rv.id = ly.post_id 
        GROUP BY rv.id, l.username, l.name, l.reels_video, l.caption
        ORDER BY RAND() LIMIT 10";

$res = mysqli_query($conn, $sql);

// Check if the query was successful
if (!$res) {
    echo json_encode(["error" => "Database query failed: " . mysqli_error($conn)]);
    exit;
}

$imageList = array();

if (mysqli_num_rows($res) > 0) {
    // Fetch all results
    while ($image = mysqli_fetch_assoc($res)) {
        // Include user_id and username in the response
        $imageList[] = [
            'reels_video' => $image['reels_video'],
            'user_id' => $image['user_id'],
            'username' => $image['username'],
            'video_caption' => $image['video_caption'],
            'created_at' => $image['created_at'],
            'name' => $image['name'],
            'image' => $image['image'],
            'user_caption' => $image['user_caption'],
            'like_count' => (int)$image['like_count'], // Cast to integer for JSON response
            'id' => $image['id'],
        ];
    }
} else {
    echo json_encode(["error" => "No videos found"]);
    exit;
}

// Return the list of random videos as a JSON response
echo json_encode($imageList);
?>