<?php
// Database connection details
$host = 'localhost';
$dbname = 'dreams';
$username = 'root'; // Replace with your actual database username
$password = ''; // Replace with your actual database password

try {
    // Create a PDO connection
    $connection = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    // Set PDO to throw exceptions on errors
    $connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if the POST request is set
    if (isset($_POST['post_id']) && isset($_POST['username']) && isset($_POST['comment'])) {
        $post_id = $_POST['post_id'];
        $username = $_POST['username'];
        $comment = $_POST['comment'];

        // Prepare the SQL query with placeholders
        $sql = "INSERT INTO comments (post_id, username, comment) VALUES (:post_id, :username, :comment)";
        $stmt = $connection->prepare($sql);

        // Bind parameters to the prepared statement
        $stmt->bindParam(':post_id', $post_id, PDO::PARAM_INT);
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->bindParam(':comment', $comment, PDO::PARAM_STR);

        // Execute the query
        if ($stmt->execute()) {
            echo "Comment posted successfully";
        } else {
            echo "Error: Failed to post comment";
        }
    } else {
        echo "Error: Missing POST data";
    }
} catch (PDOException $e) {
    // Handle database errors
    echo "Database Error: " . $e->getMessage();
} catch (Exception $e) {
    // Handle other errors
    echo "Error: " . $e->getMessage();
}
?>