<?php
// Connect to database
$conn = mysqli_connect("localhost", "root", "", "dreams");

// Check connection
if (!$conn) {
    die(json_encode(["error" => "Connection failed: " . mysqli_connect_error()]));
}

// Check if post_id is provided
if (!isset($_POST['post_id'])) {
    die(json_encode(["error" => "post_id not provided"]));
}

// Get post ID from request
$post_id = mysqli_real_escape_string($conn, $_POST['post_id']);

// Base URL for media files
$base_url = "http://192.168.151.139/dreams/uploads/";

// Get comments along with usernames and video captions
$sql = "
    SELECT comments.*, login.reels_video, login.id, login.name, login.caption
    FROM comments 
    LEFT JOIN login ON comments.username = login.username 
    WHERE comments.post_id = '$post_id'
";

// Execute the query
$result = mysqli_query($conn, $sql);

// Check for SQL errors
if (!$result) {
    die(json_encode(["error" => "SQL Error: " . mysqli_error($conn)]));
}

// Create array to store comments
$comments = array();

// Fetch comments and store in array
while ($row = mysqli_fetch_assoc($result)) {
    // Add base URL to the reels_video if it exists
    if (!empty($row['reels_video'])) {
        $row['reels_video'] = $base_url . $row['reels_video'];
    }
    $comments[] = $row;
}

// Close connection
mysqli_close($conn);

// Output comments in JSON format
header('Content-Type: application/json');
echo json_encode($comments);
?>