
<?php
$servername = "localhost"; 
$username = "root"; 
$password = ""; 
$dbname = "dreams"; // <-- अपनी DB का नाम डालें

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Connection failed: " . $conn->connect_error]));
}

$username = $_GET['username'];

// ✅ Per day कितने views हुए (उस user की सारी videos पर)
$sql = "SELECT DATE(watch_date) as day, COUNT(*) as views
        FROM video_watches
        WHERE username = ?
        GROUP BY DATE(watch_date)
        ORDER BY day ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

$dailyData = [];
while ($row = $result->fetch_assoc()) {
    $dailyData[] = $row;
}

// ✅ Total views count (उस user की सारी videos पर)
$totalSql = "SELECT COUNT(*) as total_views 
             FROM video_watches 
             WHERE username = ?";
$stmt2 = $conn->prepare($totalSql);
$stmt2->bind_param("s", $username);
$stmt2->execute();
$totalResult = $stmt2->get_result()->fetch_assoc();

// ✅ Final response
$response = [
    "daily" => $dailyData,
    "total" => $totalResult['total_views']
];

echo json_encode($response);
?>
