<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'db_connection.php';

$currentUserId = $_GET['user_id'] ?? 0;
$baseImageUrl = "http://10.63.186.51/dreams/uploads/";

try {
    // Get all distinct conversations with unread message count and profile image
    $stmt = $pdo->prepare("
        SELECT 
            CASE 
                WHEN m.sender_id = :user_id THEN m.receiver_id
                ELSE m.sender_id
            END AS other_user_id,
            l.username,
            l.reels_video AS profile_image,
            SUM(CASE WHEN m.receiver_id = :user_id AND m.sender_id != :user_id AND m.is_read = 0 THEN 1 ELSE 0 END) AS unread_count,
            MAX(m.created_at) AS last_message_time,
            (SELECT message FROM messages 
             WHERE (sender_id = m.sender_id AND receiver_id = m.receiver_id) 
                OR (sender_id = m.receiver_id AND receiver_id = m.sender_id)
             ORDER BY created_at DESC LIMIT 1) AS last_message
        FROM messages m
        JOIN login l ON l.id = CASE 
            WHEN m.sender_id = :user_id THEN m.receiver_id
            ELSE m.sender_id
        END
        WHERE m.sender_id = :user_id OR m.receiver_id = :user_id
        GROUP BY other_user_id
        ORDER BY last_message_time DESC
    ");
    
    $stmt->execute(['user_id' => $currentUserId]);
    $conversations = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Format response
    $response = [];
    foreach ($conversations as $conversation) {
        $profileImage = null;
        if (!empty($conversation['profile_image'])) {
            $profileImage = $baseImageUrl . $conversation['profile_image'];
        }
        
        $response[] = [
            'user_id' => $conversation['other_user_id'],
            'username' => $conversation['username'],
            'profile_image' => $profileImage,
            'unread_count' => (int)$conversation['unread_count'],
            'last_message' => $conversation['last_message'],
            'last_message_time' => $conversation['last_message_time']
        ];
    }

    echo json_encode($response);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage(),
        'trace' => $e->getTrace()
    ]);
}
?>