

<?php
header("Content-Type: application/json");

$host = "localhost";
$dbname = "dreams";
$username = "root";
$password = "";

try {
    $pdo = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username,
        $password
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    echo json_encode(["success" => false, "error" => $e->getMessage()]);
    exit;
}

$post_id = $_POST['post_id'] ?? null;
$usernames = $_POST['usernames'] ?? '';

if (!$post_id || empty($usernames)) {
    echo json_encode(["success" => false, "message" => "Invalid data"]);
    exit;
}

// 🔥 Convert "Rishi,Rohan,Ravi" → Array
$userList = array_map('trim', explode(",", $usernames));

$stmt = $pdo->prepare(
    "INSERT INTO likese (post_id, username) VALUES (?, ?)"
);

foreach ($userList as $user) {
    if ($user != '') {
        $stmt->execute([$post_id, $user]);
    }
}

echo json_encode([
    "success" => true,
    "count" => count($userList)
]);
