<?php
include "db_conn.php";

// Get user_id from query parameters and ensure it's provided
if (!isset($_GET['user_id'])) {
    echo json_encode(['error' => 'user_id is required']);
    exit;
}

$user_id = intval($_GET['user_id']); // Fetch and sanitize user_id

// Fetch videos for the specified user_id
$sql = "SELECT * FROM reels_videose WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$res = $stmt->get_result();

$videos = array();

if ($res->num_rows > 0) {
    while ($video = $res->fetch_assoc()) {
        // Count views for each video
        $video_id = $video['id'];
        
        // Count views
        $count_sql = "SELECT COUNT(*) AS view_count FROM video_watches WHERE video_id = ?";
        $count_stmt = $conn->prepare($count_sql);
        $count_stmt->bind_param("i", $video_id);
        $count_stmt->execute();
        $count_res = $count_stmt->get_result();
        $view_count = $count_res->fetch_assoc()['view_count'];

        // Count likes for each video
        $like_count_sql = "SELECT COUNT(*) AS like_count FROM likese WHERE post_id = ?";
        $like_count_stmt = $conn->prepare($like_count_sql);
        $like_count_stmt->bind_param("i", $video_id);
        $like_count_stmt->execute();
        $like_count_res = $like_count_stmt->get_result();
        $like_count = $like_count_res->fetch_assoc()['like_count'];

        // Add video details along with view count and like count
        $videos[] = array(
            'id' => $video['id'],
            'caption' => $video['caption'],
            'description' => $video['description'],
            'video_file' => $video['reels_video'],
            'view_count' => $view_count, // Include the view count
            'like_count' => $like_count   // Include the like count
        );
    }
}

$json_data = json_encode($videos);
echo $json_data;
?>